/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.coupling;

import com.railwayteam.railways.mixin.AccessorScheduleRuntime;
import com.railwayteam.railways.mixin.AccessorTrain;
import com.railwayteam.railways.mixin_interfaces.IIndexedSchedule;
import com.railwayteam.railways.multiloader.PlayerSelection;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.packet.AddTrainEndPacket;
import com.railwayteam.railways.util.packet.CarriageContraptionEntityUpdatePacket;
import com.railwayteam.railways.util.packet.ChopTrainEndPacket;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.logistics.trains.entity.Carriage;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraption;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.entity.TrainPacket;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleRuntime;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.utility.Components;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TrainUtils {
    public static Train splitTrain(Train train, int numberOffEnd) {
        if (train.carriages.size() <= numberOffEnd) {
            return train;
        }
        Carriage[] lastCarriages = new Carriage[numberOffEnd];
        Integer[] lastCarriageSpacings = new Integer[numberOffEnd - 1];
        for (int i = numberOffEnd - 1; i >= 0; --i) {
            lastCarriages[i] = (Carriage)train.carriages.remove(train.carriages.size() - 1);
            if (i > 0) {
                lastCarriageSpacings[i - 1] = (Integer)train.carriageSpacing.remove(train.carriageSpacing.size() - 1);
                continue;
            }
            train.carriageSpacing.remove(train.carriageSpacing.size() - 1);
        }
        double[] originalStress = ((AccessorTrain)train).snr_getStress();
        double[] newStress = new double[originalStress.length - numberOffEnd];
        System.arraycopy(originalStress, 0, newStress, 0, newStress.length);
        ((AccessorTrain)train).snr_setStress(newStress);
        Train newTrain = new Train(UUID.randomUUID(), train.owner, train.graph, new ArrayList<Carriage>(List.of(lastCarriages)), new ArrayList<Integer>(List.of(lastCarriageSpacings)), Arrays.stream(lastCarriages).anyMatch(carriage -> {
            CarriageContraption carriageContraption;
            Contraption patt2930$temp = carriage.anyAvailableEntity().getContraption();
            return patt2930$temp instanceof CarriageContraption && (carriageContraption = (CarriageContraption)patt2930$temp).hasBackwardControls();
        }));
        train.doubleEnded = train.carriages.stream().anyMatch(carriage -> {
            CarriageContraption carriageContraption;
            Contraption patt3150$temp = carriage.anyAvailableEntity().getContraption();
            return patt3150$temp instanceof CarriageContraption && (carriageContraption = (CarriageContraption)patt3150$temp).hasBackwardControls();
        });
        newTrain.name = Components.literal((String)("Split off from: " + train.name.getString()));
        int i = 0;
        while (i < lastCarriages.length) {
            Carriage lastCarriage = lastCarriages[i];
            int finalI = i++;
            lastCarriage.forEachPresentEntity(cce -> {
                cce.carriageIndex = finalI;
                cce.trainId = newTrain.id;
                cce.setCarriage(lastCarriage);
                cce.syncCarriage();
            });
        }
        newTrain.collectInitiallyOccupiedSignalBlocks();
        train.updateSignalBlocks = true;
        Create.RAILWAYS.addTrain(newTrain);
        CRPackets.PACKETS.sendTo(PlayerSelection.all(), (SimplePacketBase)new TrainPacket(newTrain, true));
        Arrays.stream(lastCarriages).forEach(c -> c.forEachPresentEntity(CarriageContraptionEntity::syncCarriage));
        train.carriages.forEach(carriage -> carriage.forEachPresentEntity(CarriageContraptionEntity::syncCarriage));
        newTrain.carriages.forEach(carriage -> carriage.forEachPresentEntity(CarriageContraptionEntity::syncCarriage));
        PlayerSelection allPlayers = PlayerSelection.all();
        Arrays.stream(lastCarriages).forEach(c -> c.forEachPresentEntity(cce -> CRPackets.PACKETS.sendTo(allPlayers, (S2CPacket)new CarriageContraptionEntityUpdatePacket((CarriageContraptionEntity)cce, newTrain))));
        CRPackets.PACKETS.sendTo(allPlayers, (S2CPacket)new ChopTrainEndPacket(train, numberOffEnd, train.doubleEnded));
        if (train.runtime.getSchedule() != null && ((IIndexedSchedule)train).getIndex() >= train.carriages.size()) {
            int newIndex = ((IIndexedSchedule)train).getIndex() - train.carriages.size();
            ((IIndexedSchedule)newTrain).setIndex(newIndex);
            newTrain.runtime.read(train.runtime.write());
            if (train.runtime.state == ScheduleRuntime.State.IN_TRANSIT) {
                newTrain.runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
                ((AccessorScheduleRuntime)newTrain.runtime).setCooldown(0);
            }
            train.runtime.discardSchedule();
        }
        if (train.carriages.size() == 0) {
            Create.RAILWAYS.removeTrain(train.id);
        }
        return newTrain;
    }

    public static Train combineTrains(Train frontTrain, Train backTrain, BlockPos itemDropPos, Level itemDropLevel, int carriageSpacing) {
        return TrainUtils.combineTrains(frontTrain, backTrain, Vec3.m_82539_((Vec3i)itemDropPos), itemDropLevel, carriageSpacing);
    }

    public static Train combineTrains(Train frontTrain, Train backTrain, Vec3 itemDropPos, Level itemDropLevel, int carriageSpacing) {
        if (frontTrain.derailed || backTrain.derailed) {
            return frontTrain;
        }
        int frontTrainSize = frontTrain.carriages.size();
        frontTrain.carriages.addAll(backTrain.carriages);
        backTrain.carriages.clear();
        frontTrain.carriageSpacing.add(carriageSpacing);
        frontTrain.carriageSpacing.addAll(backTrain.carriageSpacing);
        backTrain.carriageSpacing.clear();
        double[] newStress = new double[((AccessorTrain)frontTrain).snr_getStress().length + ((AccessorTrain)backTrain).snr_getStress().length + 1];
        System.arraycopy(((AccessorTrain)frontTrain).snr_getStress(), 0, newStress, 0, ((AccessorTrain)frontTrain).snr_getStress().length);
        newStress[((AccessorTrain)frontTrain).snr_getStress().length] = 0.0;
        System.arraycopy(((AccessorTrain)backTrain).snr_getStress(), 0, newStress, ((AccessorTrain)frontTrain).snr_getStress().length + 1, ((AccessorTrain)backTrain).snr_getStress().length);
        ((AccessorTrain)frontTrain).snr_setStress(newStress);
        frontTrain.doubleEnded = frontTrain.carriages.stream().anyMatch(carriage -> {
            CarriageContraption carriageContraption;
            Contraption patt7858$temp = carriage.anyAvailableEntity().getContraption();
            return patt7858$temp instanceof CarriageContraption && (carriageContraption = (CarriageContraption)patt7858$temp).hasBackwardControls();
        });
        for (int i = 0; i < frontTrain.carriages.size(); ++i) {
            int finalI = i;
            Carriage lastCarriage = (Carriage)frontTrain.carriages.get(i);
            lastCarriage.setTrain(frontTrain);
            ((Carriage)frontTrain.carriages.get(i)).forEachPresentEntity(cce -> {
                cce.carriageIndex = finalI;
                cce.trainId = frontTrain.id;
                cce.setCarriage(lastCarriage);
            });
        }
        if (backTrain.getCurrentStation() != null) {
            backTrain.getCurrentStation().cancelReservation(backTrain);
        }
        frontTrain.collectInitiallyOccupiedSignalBlocks();
        Create.RAILWAYS.removeTrain(backTrain.id);
        PlayerSelection allPlayers = PlayerSelection.all();
        CRPackets.PACKETS.sendTo(allPlayers, (S2CPacket)new AddTrainEndPacket(frontTrain, backTrain, carriageSpacing, backTrain.doubleEnded));
        frontTrain.carriages.forEach(carriage -> carriage.forEachPresentEntity(cce -> CRPackets.PACKETS.sendTo(allPlayers, (S2CPacket)new CarriageContraptionEntityUpdatePacket((CarriageContraptionEntity)cce, frontTrain))));
        if (frontTrain.runtime.getSchedule() == null && backTrain.runtime.getSchedule() != null) {
            ((IIndexedSchedule)frontTrain).setIndex(((IIndexedSchedule)backTrain).getIndex() + frontTrainSize);
            frontTrain.runtime.read(backTrain.runtime.write());
            if (backTrain.runtime.state == ScheduleRuntime.State.IN_TRANSIT) {
                frontTrain.runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
                ((AccessorScheduleRuntime)frontTrain.runtime).setCooldown(0);
            }
        } else if (backTrain.runtime.getSchedule() != null) {
            if (frontTrain.runtime.completed) {
                ItemStack stack = frontTrain.runtime.returnSchedule();
                Containers.m_18992_((Level)itemDropLevel, (double)itemDropPos.f_82479_, (double)itemDropPos.f_82480_, (double)itemDropPos.f_82481_, (ItemStack)stack);
                ((IIndexedSchedule)frontTrain).setIndex(((IIndexedSchedule)backTrain).getIndex() + frontTrainSize);
                frontTrain.runtime.read(backTrain.runtime.write());
                if (backTrain.runtime.state == ScheduleRuntime.State.IN_TRANSIT) {
                    frontTrain.runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
                    ((AccessorScheduleRuntime)frontTrain.runtime).setCooldown(0);
                }
            } else {
                ItemStack stack = backTrain.runtime.returnSchedule();
                Containers.m_18992_((Level)itemDropLevel, (double)itemDropPos.f_82479_, (double)itemDropPos.f_82480_, (double)itemDropPos.f_82481_, (ItemStack)stack);
            }
        }
        return frontTrain;
    }
}

